'
' Instances of this class are used to represent all kinds of sensors.
' Instances of subclasses of this class represent specialized kinds of
' sensors.
'
Public Class SimpleSensor
    ' A reference to the object that implements operations specific to
    ' the actual sensor device that this object represents.
    Private myImpl As SimpleSensorImpl

    '
    ' This constructor is intended to be called by a factory method
    ' object that is in the same package as this class and the
    ' classes that implement its operations.
    '
    ' impl - The object that implements the sensor type-specific
    '        operations this object will provide.
    '
    Public Sub New(ByVal impl As SimpleSensorImpl)
        myImpl = impl
    End Sub

    '
    ' This allows subclasses of this class to get the reference
    ' to the implementation object.
    '
    Friend ReadOnly Property Impl() As SimpleSensorImpl
        Get
            Return myImpl
        End Get
    End Property

    '
    ' Return the value of the sensor's current measurement.
    '
    Public ReadOnly Property CurrentMeasure() As Integer
        Get
            Return myImpl.CurrentMeasure
        End Get
    End Property

End Class 'SimpleSensor